<?php

namespace Minimog\Woo;

defined( 'ABSPATH' ) || exit;

/**
 * Compatible with Germanized for WooCommerce plugin.
 *
 * @see https://wordpress.org/plugins/woocommerce-germanized/
 */
class WooCommerce_Germanized {

	private static $instance = null;

	public static function instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function initialize() {
		// Fix duplicate info about shipping + tax in mini cart total.
		remove_action( 'woocommerce_widget_shopping_cart_before_buttons', 'woocommerce_gzd_template_mini_cart_taxes', 10 );
	}

	/**
	 * Check whether the plugin activated
	 *
	 * @return boolean true if plugin activated
	 */
	public function is_activated() {
		return class_exists( '\WooCommerce_Germanized' );
	}
}

WooCommerce_Germanized::instance()->initialize();
