<?php
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Minimog_Redux_Presets' ) ) {
	class Minimog_Redux_Presets {

		public static $settings = null;

		protected static $instance = null;

		public static function instance() {
			if ( null === self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function initialize() {

		}

		public static function get_settings( $preset_name ) {
			if ( null === self::$settings ) {
				self::set_settings();
			}

			if ( isset( self::$settings[ $preset_name ] ) ) {
				return self::$settings[ $preset_name ];
			}

			return array();
		}

		private static function set_settings() {
			self::$settings = [
				'megamog'   => [
					'primary_color'                      => '#AE5000',
					'heading_color'                      => '#000000',
					'typography_body'                    => [
						'font-family' => 'Work Sans',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                 => [
						'font-family' => 'Fraunces',
						'font-weight' => '400',
					],
					'typography_heading_weight_2'        => '400',
					'button_typography_custom'           => [
						'text-transform' => '',
						'font-size'      => '16px',
						'letter-spacing' => '0',
					],
					'button_typography_custom_weight'    => '500',
					'button2_text_color'                 => '#000',
					'button2_background_color'           => '#f2f2f2',
					'button2_border_color'               => '#f2f2f2',
					'button2_hover_text_color'           => '#fff',
					'button2_hover_background_color'     => '#000',
					'button2_hover_border_color'         => '#000',
					'form_text_color'                    => '#000',
					'form_background_color'              => '#f2f2f2',
					'form_border_color'                  => '#f2f2f2',
					'form_focus_text_color'              => '#000',
					'form_focus_background_color'        => '#fff',
					'form_focus_border_color'            => '#000',
					'form_input_normal_border_thickness' => 1,
					'form_input_normal_rounded'          => 5,
					'form_textarea_rounded'              => 5,
					'button_rounded'                     => 5,
					'form_typography_inherit'            => '1',
					'form_typography_custom_weight'      => '400',

					'global_top_bar'                               => 'none',
					'top_bar_style_01_content_width'               => Minimog_Site_Layout::CONTAINER_BROAD,
					'top_bar_style_01_text_typography'             => [
						'font-family'    => 'Work Sans',
						'font-weight'    => '500',
						'font-size'      => '14px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'                    => '#000',
					'global_header'                                => '06',
					'popup_search_categories_enable'               => true,
					'header_style_navigation_typography'           => [
						'font-family'    => 'Work Sans',
						'font-weight'    => '500',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_06_content_width'                => Minimog_Site_Layout::CONTAINER_BROAD,
					'header_style_08_content_width'                => Minimog_Site_Layout::CONTAINER_BROAD,
					'header_category_menu_enable'                  => '1',
					'header_category_menu_sticky_homepage'         => '1',
					'header_category_menu_link_rounded'            => 5,
					'header_search_form_style'                     => 'button-fill',
					'header_above_style_dark_background'           => array(
						'background-color' => '#414E44',
					),
					'header_above_style_dark_border_color'         => 'rgba(0,0,0,0)',
					'header_above_style_dark_item_separator_color' => '#fff',
					'header_above_style_dark_text_color'           => '#fff',
					'header_above_style_dark_link_color'           => '#fff',
					'header_above_style_dark_link_hover_color'     => 'rgba(255,255,255,0.7)',
					'header_below_style_dark_inner_border'         => [
						'border-color'  => '#eee',
						'border-style'  => 'solid',
						'border-top'    => '1px',
						'border-right'  => '0',
						'border-bottom' => '1px',
						'border-left'   => '0',
					],
					'title_bar_layout'                             => Minimog_Title_Bar::TYPE_STANDARD_03,
					'title_bar_heading_font_size'                  => 36,
					'title_bar_content_width'                      => Minimog_Site_Layout::CONTAINER_BROAD,
					'title_bar_minimal_01_text_align'              => 'flex-start',
					'title_bar_minimal_01_breadcrumb_min_height'   => [
						'height' => 58,
						'units'  => 'px',
					],
					'title_bar_minimal_01_margin'                  => [
						'margin-bottom' => '22',
						'units'         => 'px',
					],

					// Shop settings.
					'price_regular_color'                          => '#000',
					'price_old_color'                              => '#666',
					'price_sale_color'                             => '#AE5000',
					'product_archive_single_sidebar_width'         => [
						'width' => 20,
					],
					'product_archive_single_sidebar_offset'        => [
						'width' => 0,
					],
					'shop_archive_site_layout'                     => Minimog_Site_Layout::CONTAINER_BROAD,
					'shop_archive_grid_style'                      => 'grid-06',
					'shop_archive_grid_caption_style'              => '06',
					'shop_archive_show_category'                   => '1',
					'shop_archive_show_rating'                     => '1',
					'shop_archive_show_variation'                  => '0',

					'single_product_site_layout'        => Minimog_Site_Layout::CONTAINER_BROAD,
					'single_product_summary_layout'     => Minimog_Site_Layout::CONTAINER_BROAD,
					'single_product_loop_style'         => 'carousel-06',
					'single_product_loop_caption_style' => '06',
					'single_product_loop_lg_columns'    => 5,
					'single_product_loop_md_columns'    => 3,
					'single_product_loop_sm_columns'    => 2,
					'single_product_loop_lg_gutter'     => 30,
					'single_product_loop_md_gutter'     => 20,
					'single_product_loop_sm_gutter'     => 16,

					// Store settings.
					'single_store_site_layout'          => Minimog_Site_Layout::CONTAINER_BROAD,
					'store_page_single_sidebar_width'   => [
						'width' => 20,
					],
					'store_page_single_sidebar_offset'  => [
						'width' => 0,
					],
				],
				'megastore' => [
					'body_background'                    => [
						'background-color' => '#F7F7F7',
					],
					'page_blocks_style'                  => 'border-block',
					'primary_color'                      => '#B82121',
					'heading_color'                      => '#000000',
					'typography_body'                    => [
						'font-family' => 'Satoshi',
						'font-weight' => '500',
						'font-size'   => '16px',
						'line-height' => '24px',
					],
					'typography_heading'                 => [
						'font-family' => 'Satoshi',
						'font-weight' => '900',
					],
					'typography_heading_weight_2'        => '700',
					'button_typography_custom'           => [
						'text-transform' => '',
						'font-size'      => '16px',
						'letter-spacing' => '0',
					],
					'button_typography_custom_weight'    => '500',
					'button2_text_color'                 => '#000',
					'button2_background_color'           => '#EDEDED',
					'button2_border_color'               => '#EDEDED',
					'button2_hover_text_color'           => '#fff',
					'button2_hover_background_color'     => '#000',
					'button2_hover_border_color'         => '#000',
					'form_input_normal_border_thickness' => 1,
					'form_input_normal_rounded'          => 0,
					'form_textarea_rounded'              => 0,
					'button_rounded'                     => 0,
					'form_typography_inherit'            => '1',
					'form_typography_custom_weight'      => '500',

					'global_header'                               => '06',
					'popup_search_categories_enable'              => true,
					'top_bar_style_01_text_typography'            => [
						'font-family' => 'Satoshi',
						'font-weight' => '700',
						'font-size'   => '14px',
						'line-height' => '26px',
						'color'       => '#ffffff',
					],
					'top_bar_style_01_bg_color'                   => '#B82121',
					'top_bar_style_01_tag_color'                  => '#000',
					'top_bar_style_01_tag_background'             => '#fff',
					'top_bar_style_01_content_width'              => Minimog_Site_Layout::CONTAINER_NORMAL,
					'top_bar_style_01_layout'                     => '2',
					'top_bar_style_01_left_components'            => [
						'text' => true,
					],
					'top_bar_style_01_right_components'           => [
						'language_switcher' => true,
						'currency_switcher' => true,
						'social_links'      => true,
					],
					'header_style_navigation_typography'          => [
						'font-family'    => 'Satoshi',
						'font-weight'    => '900',
						'font-size'      => '14px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '',
					],
					'header_search_form_style'                    => 'button-fill',
					'header_style_06_content_width'               => Minimog_Site_Layout::CONTAINER_NORMAL,
					'header_style_08_content_width'               => Minimog_Site_Layout::CONTAINER_NORMAL,
					'header_style_06_header_above_enable'         => '0',
					'header_style_08_header_above_enable'         => '0',
					'header_category_menu_enable'                 => '1',
					'header_category_menu_sticky_homepage'        => '1',
					'header_category_menu_background_color'       => '#fff',
					'header_category_menu_border_color'           => '#eee',
					'header_category_menu_link_color'             => '#000',
					'header_category_menu_link_hover_color'       => '#fff',
					'header_category_menu_link_hover_background'  => '#000',
					'header_category_menu_link_arrow_color'       => '#999',
					'header_category_menu_link_hover_arrow_color' => '#fff',
					'header_category_menu_link_hover_shadow'      => false,
					'header_category_menu_link_rounded'           => 0,
					'header_below_style_dark_border'              => [
						'border-color'  => '#eee',
						'border-style'  => 'solid',
						'border-top'    => '1px',
						'border-right'  => '0',
						'border-bottom' => '1px',
						'border-left'   => '0',
					],
					'title_bar_layout'                            => Minimog_Title_Bar::TYPE_STANDARD_03,
					'title_bar_heading_font_size'                 => 36,
					'title_bar_content_width'                     => Minimog_Site_Layout::CONTAINER_NORMAL,
					'title_bar_minimal_01_text_align'             => 'flex-start',
					'title_bar_minimal_01_breadcrumb_min_height'  => [
						'height' => 52,
						'units'  => 'px',
					],
					'title_bar_minimal_01_margin'                 => [
						'margin-bottom' => '22',
						'units'         => 'px',
					],

					// Shop settings.
					'shop_badges_style'                           => 'square-label',
					'price_regular_color'                         => '#666',
					'price_old_color'                             => '#666',
					'price_sale_color'                            => '#B82121',
					'product_archive_title_bar_layout'            => Minimog_Title_Bar::DEFAULT_MINIMAL_TYPE,
					'product_archive_single_sidebar_width'        => [
						'width' => 25,
					],
					'product_archive_single_sidebar_offset'       => [
						'width' => 0,
					],
					'shop_archive_site_layout'                    => Minimog_Site_Layout::CONTAINER_NORMAL,
					'shop_archive_page_title'                     => '1',
					'shop_archive_grid_style'                     => 'grid-08',
					'shop_archive_grid_caption_style'             => '05',
					'shop_archive_lg_gutter'                      => 0,
					'shop_archive_md_gutter'                      => 0,
					'shop_archive_sm_gutter'                      => 0,
					'shop_archive_show_category'                  => '1',
					'shop_archive_show_rating'                    => '0',
					'shop_archive_show_variation'                 => '0',
					'product_archive_sidebar_style'               => '02',

					'single_product_site_layout'        => Minimog_Site_Layout::CONTAINER_NORMAL,
					'single_product_summary_layout'     => Minimog_Site_Layout::CONTAINER_NORMAL,
					'single_product_images_wide'        => 'extended',
					'single_product_summary_offset'     => '0',
					'single_product_loop_style'         => 'carousel-08',
					'single_product_loop_caption_style' => '05',
					'single_product_loop_lg_columns'    => 6,
					'single_product_loop_md_columns'    => 4,
					'single_product_loop_sm_columns'    => 2,
					'single_product_loop_lg_gutter'     => 0,
					'single_product_loop_md_gutter'     => 0,
					'single_product_loop_sm_gutter'     => 0,

					// Blog settings.
					'blog_archive_title_bar_layout'     => Minimog_Title_Bar::DEFAULT_MINIMAL_TYPE,
					'blog_archive_page_sidebar_style'   => '02',
					'post_page_sidebar_style'           => '02',
				],
				'supergear' => [
					'primary_color'                   => '#E02B2B',
					'heading_color'                   => '#000000',
					'typography_body'                 => [
						'font-family' => 'GeneralSans',
						'font-weight' => '500',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'              => [
						'font-family' => 'GeneralSans',
						'font-weight' => '600',
					],
					'typography_heading_weight_2'     => '600',
					'button_typography_custom'        => [
						'text-transform' => 'uppercase',
						'font-size'      => '14px',
						'letter-spacing' => '0',
					],
					'button_typography_custom_weight' => '600',
					'button2_text_color'              => '#000',
					'button2_background_color'        => '#f2f2f2',
					'button2_border_color'            => '#f2f2f2',
					'button2_hover_text_color'        => '#fff',
					'button2_hover_background_color'  => '#000',
					'button2_hover_border_color'      => '#000',
					'form_input_small_rounded'        => 20,
					'form_input_normal_rounded'       => 23,
					'form_textarea_rounded'           => 5,
					'button_small_rounded'            => 20,
					'button_rounded'                  => 23,
					'button_large_rounded'            => 25,
					'form_typography_inherit'         => '1',
					'form_typography_custom_weight'   => '400',

					'global_top_bar'                             => 'none',
					'top_bar_style_01_content_width'             => Minimog_Site_Layout::CONTAINER_BROAD,
					'top_bar_style_01_text_typography'           => [
						'font-family'    => 'GeneralSans',
						'font-weight'    => '500',
						'font-size'      => '14px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'                  => '#E02B2B',
					'global_header'                              => '08',
					'popup_search_categories_enable'             => true,
					'header_search_form_style'                   => 'thick-border',
					'header_style_navigation_typography'         => [
						'font-family'    => 'GeneralSans',
						'font-weight'    => '600',
						'font-size'      => '14px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '',
					],
					'header_style_08_content_width'              => Minimog_Site_Layout::CONTAINER_BROAD,
					'title_bar_layout'                           => Minimog_Title_Bar::TYPE_STANDARD_03,
					'title_bar_heading_font_size'                => 36,
					'title_bar_content_width'                    => Minimog_Site_Layout::CONTAINER_BROAD,
					'title_bar_minimal_01_text_align'            => 'flex-start',
					'title_bar_minimal_01_breadcrumb_min_height' => [
						'height' => 60,
						'units'  => 'px',
					],

					// Shop settings.
					'price_regular_color'                        => '#32BDE8',
					'price_old_color'                            => '#777',
					'price_sale_color'                           => '#E02B2B',
					'product_archive_single_sidebar_width'       => [
						'width' => 20,
					],
					'product_archive_single_sidebar_offset'      => [
						'width' => 0,
					],
					'shop_archive_site_layout'                   => Minimog_Site_Layout::CONTAINER_BROAD,
					'shop_archive_grid_style'                    => 'grid-06',
					'shop_archive_grid_caption_style'            => '05',
					'shop_archive_show_category'                 => '1',
					'shop_archive_show_rating'                   => '1',
					'shop_archive_show_variation'                => '0',

					'single_product_site_layout'        => Minimog_Site_Layout::CONTAINER_BROAD,
					'single_product_summary_layout'     => Minimog_Site_Layout::CONTAINER_BROAD,
					'single_product_loop_style'         => 'carousel-06',
					'single_product_loop_caption_style' => '05',
					'single_product_loop_lg_columns'    => 6,
					'single_product_loop_md_columns'    => 4,
					'single_product_loop_sm_columns'    => 2,
					'single_product_loop_lg_gutter'     => 30,
					'single_product_loop_md_gutter'     => 20,
					'single_product_loop_sm_gutter'     => 16,
				],
				'autopart'  => [
					'primary_color'                                 => '#ED5121',
					'heading_color'                                 => '#0A2939',
					'link_color'                                    => '#0A2939',
					'typography_body'                               => [
						'font-family' => 'Roboto',
						'font-weight' => '400', // 500
						'font-size'   => '16px',
						'line-height' => '26px',
					],
					'typography_heading'                            => [
						'font-family' => 'Roboto',
						'font-weight' => '400',
					],
					'button_typography_custom'                      => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight'               => '700',
					'button_rounded'                                => 23,
					'button_small_rounded'                          => 20,
					'button_large_rounded'                          => 25,
					'form_textarea_rounded'                         => 5,
					'form_input_small_rounded'                      => 20,
					'form_input_normal_rounded'                     => 23,
					'button_text_color'                             => '#fff',
					'button_background_color'                       => '#ED5121',
					'button_border_color'                           => '#ED5121',
					'button_hover_text_color'                       => '#fff',
					'button_hover_background_color'                 => '#ED5121',
					'button_hover_border_color'                     => '#ED5121',
					'button2_text_color'                            => '#0A2939',
					'button2_background_color'                      => 'rgba(0,0,0,0)',
					'button2_border_color'                          => '#0A2939',
					'button2_hover_text_color'                      => '#fff',
					'button2_hover_background_color'                => '#0A2939',
					'button2_hover_border_color'                    => '#0A2939',
					'top_bar_style_01_text_typography'              => [
						'font-family' => 'Roboto',
						'font-weight' => '500',
						'font-size'   => '16px',
						'line-height' => '26px',
						'color'       => '#ffffff',
					],
					'top_bar_style_01_bg_color'                     => '#ED5121',
					'top_bar_style_01_content_width'                => Minimog_Site_Layout::CONTAINER_EXTENDED,
					'global_header'                                 => '10',
					'global_header_skin'                            => 'light',
					'header_style_light_background'                 => [
						'background-color' => '#0A2939',
					],
					'header_icons_display'                          => 'text',
					'header_icons_style'                            => 'icon-set-04',
					'header_cart_icon_style'                        => 'icon-circle-price-02',
					'header_style_navigation_typography'            => [
						'font-family'    => 'Roboto',
						'font-weight'    => '700',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => 'capitalize',
						'letter-spacing' => '',
					],
					'header_category_menu_enable'                   => '1',
					'header_style_light_nav_line_color'             => '#ED5121',
					'header_style_light_category_menu_toggle_color' => '#ED5121',
					'header_category_menu_background_color'         => '#fff',
					'header_category_menu_link_color'               => '#666',
					'header_category_menu_link_hover_color'         => '#000',
					'header_category_menu_link_hover_background'    => 'rgba(61,61,80,0.09)',
					'header_category_menu_link_rounded'             => 5,
					'header_style_light_form_submit_text_color'     => '#0A2939',
					'header_style_light_form_text_color'            => '#0A2939',
					'header_style_light_form_background_color'      => '#fff',
					'header_style_light_form_border_color'          => '#fff',
					'title_bar_layout'                              => Minimog_Title_Bar::TYPE_STANDARD_03,
					'title_bar_heading_font_size'                   => 36,
					'title_bar_content_width'                       => Minimog_Site_Layout::CONTAINER_EXTENDED,
					'title_bar_minimal_01_breadcrumb_min_height'    => [
						'height' => 58,
						'units'  => 'px',
					],
					'title_bar_minimal_01_margin'                   => [
						'margin-bottom' => '22',
						'units'         => 'px',
					],
					'shop_badges_style'                             => 'label-02',
					'shop_badge_sale_text_color'                    => '#fff',
					'shop_badge_sale_background_color'              => '#34AA55',
					'price_regular_color'                           => '#0A2939',
					'price_old_color'                               => '#999',
					'price_sale_color'                              => '#ED5121',

					'product_archive_single_sidebar_width'  => [
						'width' => 20,
					],
					'product_archive_single_sidebar_offset' => [
						'width' => 0,
					],
					'shop_archive_site_layout'              => Minimog_Site_Layout::CONTAINER_EXTENDED,
					'shop_archive_show_rating'              => '1',
					'shop_archive_show_variation'           => '0',
					'shop_archive_grid_style'               => 'grid-10',

					'single_product_site_layout'    => Minimog_Site_Layout::CONTAINER_EXTENDED,
					'single_product_summary_layout' => Minimog_Site_Layout::CONTAINER_EXTENDED,
					'single_product_loop_style'     => 'carousel-10',
				],
				'rtl'       => [
					'primary_color'                      => '#B67952',
					'heading_color'                      => '#000000',
					'typography_body'                    => [
						'font-family' => 'GeezaPro',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '24px',
					],
					'typography_heading'                 => [
						'font-family' => 'GeezaPro',
						'font-weight' => '400',
					],
					'typography_heading_weight_2'        => '700',
					'button_typography_custom'           => [
						'text-transform' => '',
						'font-size'      => '16px',
						'letter-spacing' => '0',
					],
					'button_typography_custom_weight'    => '700',
					'button_text_color'                  => '#ffffff',
					'button_hover_text_color'            => '#ffffff',
					'button_background_color'            => '#B67952',
					'button_border_color'                => '#B67952',
					'button_hover_background_color'      => '#B67952',
					'button_hover_border_color'          => '#B67952',
					'form_text_color'                    => '#000',
					'form_background_color'              => '#fff',
					'form_border_color'                  => 'rgba(0,0,0,0.3)',
					'form_focus_text_color'              => '#000',
					'form_focus_background_color'        => '#fff',
					'form_focus_border_color'            => '#000',
					'form_input_normal_border_thickness' => 1,
					'form_input_normal_rounded'          => 5,
					'form_textarea_rounded'              => 5,
					'button_rounded'                     => 5,
					'form_typography_inherit'            => '1',
					'form_typography_custom_weight'      => '400',
					'top_bar_style_01_text_typography'   => [
						'font-family' => 'GeezaPro',
						'font-weight' => '700',
						'font-size'   => '14px',
						'line-height' => '26px',
						'color'       => '#ffffff',
					],
					'top_bar_style_01_bg_color'          => '#D2AA91',
					'top_bar_style_01_tag_color'         => '#000',
					'top_bar_style_01_tag_background'    => '#fff',
					'header_style_navigation_typography' => [
						'font-family'    => 'GeezaPro',
						'font-weight'    => '400',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => 'none',
						'letter-spacing' => '',
					],
				],
				'home-fashion-v9'     => [
					'header_above_style_dark_background'           => array(
						'background-color' => '#000',
					),
					'header_above_style_dark_border_color'         => 'rgba(0,0,0,0)',
					'header_above_style_dark_item_separator_color' => '#fff',
					'header_above_style_dark_text_color'           => '#fff',
					'header_above_style_dark_link_color'           => '#fff',
					'header_above_style_dark_link_hover_color'     => 'rgba(255,255,255,0.7)',
				],
				'home-watch'          => [
					'body_color'                                    => '#777777',
					'typography_body'                               => [
						'font-family' => 'Syne',
						'font-weight' => '500', // 700
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-family'    => 'Syne',
						'font-weight'    => '700',
						'text-transform' => 'uppercase',
					],
					'typography_heading2'                           => [
						'font-family' => 'Syne',
						'font-weight' => '700',
					],
					'button_typography_custom'                      => [
						'text-transform' => 'uppercase',
						'font-size'      => '14px',
					],
					'button_typography_custom_weight'               => '700',
					'form_input_small_rounded'                      => 0,
					'form_input_normal_rounded'                     => 0,
					'form_textarea_rounded'                         => 0,
					'button_small_rounded'                          => 0,
					'button_rounded'                                => 0,
					'button_large_rounded'                          => 0,
					'top_bar_style_01_text_typography'              => [
						'font-family' => 'Syne',
						'font-weight' => '500',
						'font-size'   => '15px',
						'line-height' => '26px',
						'color'       => '#ffffff',
					],
					'header_style_navigation_typography'            => [
						'font-family'    => 'Syne',
						'font-weight'    => '700',
						'font-size'      => '14px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '0',
					],
					'header_search_form_style'                      => 'thick-bottom-line',
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_above_style_dark_background'            => array(
						'background-color' => '#000',
					),
					'header_above_style_dark_border_color'          => 'rgba(0,0,0,0)',
					'header_above_style_dark_item_separator_color'  => '#fff',
					'header_above_style_dark_text_color'            => '#fff',
					'header_above_style_dark_link_color'            => '#fff',
					'header_above_style_dark_link_hover_color'      => 'rgba(255,255,255,0.7)',
					'header_style_05_info_list_secondary_enable'    => '1',
					'header_style_05_language_switcher_enable'      => '0',
				],
				'home-bra'            => [
					'primary_color'                                 => '#AF593C',
					'typography_heading2'                           => [
						'font-family' => 'Prata',
						'font-weight' => '400',
					],
					'button_typography_custom'                      => [
						'text-transform' => 'uppercase',
						'font-size'      => '14px',
					],
					'button_typography_custom_weight'               => '600',
					'form_input_small_rounded'                      => 0,
					'form_input_normal_rounded'                     => 0,
					'form_textarea_rounded'                         => 0,
					'button_small_rounded'                          => 0,
					'button_rounded'                                => 0,
					'button_large_rounded'                          => 0,
					'top_bar_style_01_text_typography'              => [
						'font-family' => Minimog::PRIMARY_FONT,
						'font-weight' => '400',
						'font-size'   => '15px',
						'line-height' => '26px',
						'color'       => '#ffffff',
					],
					'header_style_navigation_typography'            => [
						'font-family'    => Minimog::PRIMARY_FONT,
						'font-weight'    => '600',
						'font-size'      => '14px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '0',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
				],
				'home-case-phone'     => [
					'typography_body'                               => [
						'font-family' => 'Poppins',
						'font-weight' => '400', // 700, 900
						'font-size'   => '15px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-family'    => 'Poppins',
						'font-weight'    => '900',
						'text-transform' => 'uppercase',
					],
					'typography_heading2'                           => [
						'font-family'    => 'Poppins',
						'font-weight'    => '900',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom'                      => [
						'text-transform' => 'uppercase',
						'font-size'      => '15px',
					],
					'button_typography_custom_weight'               => '700',
					'form_input_small_rounded'                      => 0,
					'form_input_normal_rounded'                     => 0,
					'form_textarea_rounded'                         => 0,
					'button_small_rounded'                          => 0,
					'button_rounded'                                => 0,
					'button_large_rounded'                          => 0,
					'top_bar_style_01_text_typography'              => [
						'font-family' => 'Poppins',
						'font-weight' => '500',
						'font-size'   => '15px',
						'line-height' => '26px',
						'color'       => '#ffffff',
					],
					'header_style_navigation_typography'            => [
						'font-family'    => 'Poppins',
						'font-weight'    => '700',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '0',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_style_01_search_enable'                 => 'inline',
				],
				'home-backpack'       => [
					'typography_body'                               => [
						'font-family' => 'Poppins',
						'font-weight' => '500',
						'font-size'   => '15px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-family'    => 'Poppins',
						'font-weight'    => '700',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom'                      => [
						'text-transform' => 'uppercase',
						'font-size'      => '14px',
						'letter-spacing' => '0.5px',
					],
					'button_typography_custom_weight'               => '700',
					'header_style_navigation_typography'            => [
						'font-family'    => 'Poppins',
						'font-weight'    => '700',
						'font-size'      => '14px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '0.5px',
					],
					'header_style_dark_text_color'                  => '#666',
					'header_style_dark_link_color'                  => '#666',
					'header_style_dark_link_hover_color'            => '#999',
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
				],
				'home-drink'          => [
					'primary_color'                                 => '#F1BB2F',
					'typography_body'                               => [
						'font-family' => 'Montserrat',
						'font-weight' => '500',
						'font-size'   => '15px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-family'    => 'Montserrat',
						'font-weight'    => '800',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'typography_heading_weight_2'                   => '800',
					'button_typography_inherit'                     => '0',
					'button_typography'                             => [
						'font-family'    => 'Montserrat',
						'font-weight'    => '800',
						'text-transform' => 'uppercase',
						'font-size'      => '14px',
						'letter-spacing' => '1px',
					],
					'button_text_color'                             => '#000',
					'button_background_color'                       => '#F1BB2F',
					'button_border_color'                           => '#F1BB2F',
					'button_hover_text_color'                       => '#000',
					'button_hover_background_color'                 => '#F1BB2F',
					'button_hover_border_color'                     => '#F1BB2F',
					'form_input_small_rounded'                      => 0,
					'form_input_normal_rounded'                     => 0,
					'form_textarea_rounded'                         => 0,
					'button_small_rounded'                          => 0,
					'button_rounded'                                => 0,
					'button_large_rounded'                          => 0,
					'top_bar_style_01_text_typography'              => [
						'font-family' => 'Montserrat',
						'font-weight' => '600',
						'font-size'   => '15px',
						'line-height' => '26px',
						'color'       => '#ffffff',
					],
					'header_style_navigation_typography'            => [
						'font-family'    => 'Montserrat',
						'font-weight'    => '800',
						'font-size'      => '14px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'header_style_dark_icon_badge_text_color'       => '#000',
					'header_style_dark_icon_badge_background_color' => '#F1BB2F',
					'header_sticky_icon_badge_text_color'           => '#000',
					'header_sticky_icon_badge_background_color'     => '#F1BB2F',
				],
				'home-stationery'     => [
					'typography_body'                    => [
						'font-family' => 'Roboto',
						'font-weight' => '400', // 500
						'font-size'   => '16px',
						'line-height' => '19px',
					],
					'typography_heading'                 => [
						'font-family' => 'Roboto',
						'font-weight' => '400',
					],
					'button_typography_custom'           => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight'    => '500',
					'form_input_small_rounded'           => 0,
					'form_input_normal_rounded'          => 0,
					'form_textarea_rounded'              => 0,
					'button_small_rounded'               => 0,
					'button_rounded'                     => 0,
					'button_large_rounded'               => 0,
					'top_bar_style_01_text_typography'   => [
						'font-family' => 'Roboto',
						'font-weight' => '500',
						'font-size'   => '16px',
						'line-height' => '26px',
						'color'       => '#ffffff',
					],
					'header_style_navigation_typography' => [
						'font-family'    => 'Roboto',
						'font-weight'    => '500',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => '',
						'letter-spacing' => '',
					],
				],
				'home-sneaker'        => [
					'typography_body'                    => [
						'font-family' => 'Roboto Condensed',
						'font-weight' => '400', // 700
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                 => [
						'font-family'    => 'Roboto Condensed',
						'font-weight'    => '700',
						'text-transform' => 'uppercase',
					],
					'typography_heading_weight_2'        => '700',
					'button_typography_custom'           => [
						'font-size'      => '16px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'    => '700',
					'form_input_small_rounded'           => 0,
					'form_input_normal_rounded'          => 0,
					'form_textarea_rounded'              => 0,
					'button_small_rounded'               => 0,
					'button_rounded'                     => 0,
					'button_large_rounded'               => 0,
					'top_bar_style_01_text_typography'   => [
						'font-family' => 'Roboto Condensed',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '26px',
						'color'       => '#ffffff',
					],
					'header_style_navigation_typography' => [
						'font-family'    => 'Roboto Condensed',
						'font-weight'    => '700',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '0',
					],
				],
				'home-art'            => [
					'typography_body'                               => [
						'font-family' => 'Rubik',
						'font-weight' => '400', // 500
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-family' => 'Rubik',
						'font-weight' => '500',
					],
					'typography_heading_weight_2'                   => '500',
					'button_typography_custom'                      => [
						'font-size' => '15px',
					],
					'button_typography_custom_weight'               => '500',
					'top_bar_style_01_text_typography'              => [
						'font-family' => 'Rubik',
						'font-weight' => '500',
						'font-size'   => '15px',
						'line-height' => '26px',
						'color'       => '#ffffff',
					],
					'header_style_navigation_typography'            => [
						'font-family'    => 'Rubik',
						'font-weight'    => '500',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
					'header_style_03_search_enable'                 => 'inline',
				],
				'home-toy'            => [
					'primary_color'                      => '#F08177',
					'typography_body'                    => [
						'font-family' => 'Quicksand',
						'font-weight' => '500', // 700
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                 => [
						'font-family' => 'Quicksand',
						'font-weight' => '500',
					],
					'typography_heading_weight_2'        => '700',
					'button_typography_custom'           => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight'    => '700',
					'button_rounded'                     => 23,
					'button_small_rounded'               => 20,
					'button_large_rounded'               => 25,
					'form_input_small_rounded'           => 20,
					'form_input_normal_rounded'          => 23,
					'form_textarea_rounded'              => 5,
					'top_bar_style_01_text_typography'   => [
						'font-family' => 'Quicksand',
						'font-weight' => '700',
						'font-size'   => '16px',
						'line-height' => '26px',
						'color'       => '#5FA6B1',
					],
					'top_bar_style_01_bg_color'          => '#D6F1F4',
					'top_bar_style_01_link_color'        => '#5FA6B1',
					'top_bar_style_01_link_hover_color'  => '#5FA6B1',
					'header_style_navigation_typography' => [
						'font-family'    => 'Quicksand',
						'font-weight'    => '700',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => '',
						'letter-spacing' => '',
					],
				],
				'home-living'         => [
					'typography_heading2'                           => [
						'font-family' => 'Italiana',
						'font-weight' => '400',
					],
					'typography_heading_weight_2'                   => '400',
					'button_typography_custom'                      => [
						'font-size'      => '14px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'button_typography_custom_weight'               => '500',
					'form_input_small_rounded'                      => 0,
					'form_input_normal_rounded'                     => 0,
					'form_textarea_rounded'                         => 0,
					'button_small_rounded'                          => 0,
					'button_rounded'                                => 0,
					'button_large_rounded'                          => 0,
					'header_style_navigation_typography'            => [
						'font-family'    => 'Jost',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '0',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
				],
				'home-glasses'        => [
					'typography_heading'                            => [
						'font-weight'    => '700',
						'letter-spacing' => '0.57px',
					],
					'typography_heading_weight_2'                   => '700',
					'button_typography_custom'                      => [
						'font-size'      => '14px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '0.5px',
					],
					'button_typography_custom_weight'               => '700',
					'button_rounded'                                => 23,
					'button_small_rounded'                          => 20,
					'button_large_rounded'                          => 25,
					'form_input_normal_rounded'                     => 23,
					'form_input_small_rounded'                      => 20,
					'form_textarea_rounded'                         => 5,
					'header_style_navigation_typography'            => [
						'font-family'    => 'Jost',
						'font-weight'    => '700',
						'font-size'      => '14px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '0.5px',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
					'header_above_style_dark_background'            => array(
						'background-color' => '#000000',
					),
					'header_above_style_dark_border_color'          => 'rgba(0,0,0,0)',
					'header_above_style_dark_item_separator_color'  => '#fff',
					'header_above_style_dark_text_color'            => '#fff',
					'header_above_style_dark_link_color'            => '#fff',
					'header_above_style_dark_link_hover_color'      => 'rgba(255,255,255,0.7)',
				],
				'home-plants'         => [
					'primary_color'                      => '#CD783E',
					'typography_body'                    => [
						'font-family' => 'Poppins',
						'font-weight' => '400', // 600
						'font-size'   => '15px',
						'line-height' => '28px',
					],
					'typography_heading'                 => [
						'font-family' => 'Poppins',
						'font-weight' => '400',
					],
					'typography_heading_weight_2'        => '600',
					'button_typography_custom'           => [
						'font-size' => '15px',
					],
					'button_typography_custom_weight'    => '600',
					'form_input_small_rounded'           => 0,
					'form_input_normal_rounded'          => 0,
					'form_textarea_rounded'              => 0,
					'button_small_rounded'               => 0,
					'button_rounded'                     => 0,
					'button_large_rounded'               => 0,
					'top_bar_style_01_text_typography'   => [
						'font-family' => 'Poppins',
						'font-weight' => '500',
						'font-size'   => '15px',
						'line-height' => '26px',
						'color'       => '#ffffff',
					],
					'header_style_navigation_typography' => [
						'font-family'    => 'Poppins',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => '',
						'letter-spacing' => '',
					],
				],
				'home-coffee'         => [
					'typography_heading2'                           => [
						'font-family' => 'Butler',
						'font-weight' => '300',
					],
					'typography_heading_weight_2'                   => '300',
					'button_typography_custom'                      => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight'               => '500',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Jost',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#ffffff',
						'text-transform' => 'uppercase',
						'letter-spacing' => '2px',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
					'header_height'                                 => [
						'height' => 100,
						'units'  => 'px',
					],
				],
				'home-bedding'        => [
					'typography_heading'                            => [
						'font-family' => 'Butler',
						'font-weight' => '300',
					],
					'button_typography_custom'                      => [
						'font-size'      => '15px',
						'letter-spacing' => '0.1px',
					],
					'button_typography_custom_weight'               => '500',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Jost',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#000',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'                     => '#E0E7E4',
					'top_bar_style_01_link_color'                   => '#000000',
					'top_bar_style_01_link_hover_color'             => '#000000',
					'header_style_navigation_typography'            => [
						'font-family'    => 'Jost',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
					'logo_padding'                                  => array(
						'padding-top'    => '11',
						'padding-right'  => '0',
						'padding-bottom' => '11',
						'padding-left'   => '0',
						'units'          => 'px',
					),
				],
				'home-print'          => [
					'form_text_color'                               => '#000',
					'form_background_color'                         => '#f0f0f0',
					'form_border_color'                             => '#f0f0f0',
					'form_focus_text_color'                         => '#000',
					'form_focus_background_color'                   => '#fff',
					'form_focus_border_color'                       => '#000',
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_above_style_dark_background'            => array(
						'background-color' => '#E7C5F8',
					),
					'header_above_style_dark_border_color'          => 'rgba(0,0,0,0)',
					'header_above_style_dark_item_separator_color'  => '#000',
					'header_above_style_dark_text_color'            => '#000',
					'header_above_style_dark_link_color'            => '#000',
					'header_above_style_dark_link_hover_color'      => 'rgba(0,0,0,0.7)',
					'header_style_06_info_list_enable'              => '0',
					'header_style_06_currency_switcher_enable'      => '0',
					'header_style_06_language_switcher_enable'      => '0',
				],
				'home-activewear'     => [
					'form_input_small_rounded'                      => 18,
					'form_input_normal_rounded'                     => 23,
					'button_typography_custom'                      => [
						'font-size'      => '14px',
						'letter-spacing' => '0.5px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'               => '700',
					'header_style_navigation_typography'            => [
						'font-family'    => 'Jost',
						'font-weight'    => '600',
						'font-size'      => '14px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
					'header_above_style_dark_background'            => array(
						'background-color' => '#000',
					),
					'header_above_style_dark_border_color'          => 'rgba(0,0,0,0)',
					'header_above_style_dark_item_separator_color'  => '#fff',
					'header_above_style_dark_text_color'            => '#fff',
					'header_above_style_dark_link_color'            => '#fff',
					'header_above_style_dark_link_hover_color'      => 'rgba(255,255,255,0.7)',
					'header_style_01_search_enable'                 => 'inline',
				],
				'home-furniture'      => [
					'typography_body'                               => [
						'font-family' => 'Satoshi',
						'font-weight' => '400', // 500
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading_weight_2'                   => '700',
					'typography_heading'                            => [
						'font-family' => 'Satoshi',
						'font-weight' => '500',
					],
					'button_typography_custom'                      => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight'               => '500',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Satoshi',
						'font-weight'    => '400',
						'font-size'      => '14px',
						'line-height'    => '26px',
						'color'          => '#000',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'top_bar_style_01_bg_color'                     => '#CBC9BE',
					'top_bar_style_01_link_color'                   => '#000000',
					'top_bar_style_01_link_hover_color'             => '#000000',
					'header_style_navigation_typography'            => [
						'font-family'    => 'Satoshi',
						'font-weight'    => '500',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-skateboard'     => [
					'typography_body'                                => [
						'font-family' => 'Montserrat',
						'font-weight' => '500', // 800
						'font-size'   => '15px',
						'line-height' => '28px',
					],
					'typography_heading_weight_2'                    => '800',
					'typography_heading'                             => [
						'font-family'    => 'Montserrat',
						'font-weight'    => '800',
						'letter-spacing' => '1px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom'                       => [
						'font-size'      => '14px',
						'letter-spacing' => '1px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'                => '800',
					'form_input_small_rounded'                       => 0,
					'form_input_normal_rounded'                      => 0,
					'form_textarea_rounded'                          => 0,
					'button_small_rounded'                           => 0,
					'button_rounded'                                 => 0,
					'button_large_rounded'                           => 0,
					'top_bar_style_01_text_typography'               => [
						'font-family'    => 'Montserrat',
						'font-weight'    => '700',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => 'uppercase',
					],
					'top_bar_style_01_bg_color'                      => '#D22727',
					'top_bar_style_01_link_color'                    => '#fff',
					'top_bar_style_01_link_hover_color'              => 'rgba(255,255,255,0.7)',
					'header_style_navigation_typography'             => [
						'font-family'    => 'Montserrat',
						'font-weight'    => '800',
						'font-size'      => '14px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'header_style_dark_icon_badge_text_color'        => '#fff',
					'header_style_dark_icon_badge_background_color'  => '#000',
					'header_style_light_icon_badge_text_color'       => '#fff',
					'header_style_light_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'            => '#fff',
					'header_sticky_icon_badge_background_color'      => '#000',
				],
				'home-pizza'          => [
					'primary_color'                      => '#D22727',
					'typography_body'                    => [
						'font-family' => 'Roboto Condensed',
						'font-weight' => '400', // 700 900
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                 => [
						'font-family'    => 'Roboto Condensed',
						'font-weight'    => '700',
						'text-transform' => 'uppercase',
					],
					'typography_heading_weight_2'        => '700',
					'typography_heading2'                => [
						'font-family'    => 'WorthbitesRough',
						'font-weight'    => '400',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom'           => [
						'font-size'      => '16px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'    => '700',
					'button_rounded'                     => 0,
					'form_input_normal_rounded'          => 0,
					'top_bar_style_01_text_typography'   => [
						'font-family'    => 'Roboto Condensed',
						'font-weight'    => '700',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => 'uppercase',
					],
					'top_bar_style_01_bg_color'          => '#D22727',
					'top_bar_style_01_link_color'        => '#fff',
					'top_bar_style_01_link_hover_color'  => 'rgba(255,255,255,0.7)',
					'header_style_navigation_typography' => [
						'font-family'    => 'Roboto Condensed',
						'font-weight'    => '700',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
				],
				'home-jewelry'        => [
					'typography_body'                               => [
						'font-family' => 'Futura',
						'font-weight' => '300', // 500
						'font-size'   => '15px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-family'    => 'Futura',
						'font-weight'    => '500',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1.5px',
					],
					'typography_heading_weight_2'                   => '500',
					'typography_heading2'                           => [
						'font-family'    => 'Futura',
						'font-weight'    => '500',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1.5px',
					],
					'button_typography_custom'                      => [
						'font-size'      => '14px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'button_typography_custom_weight'               => '500',
					'form_typography_custom_weight'                 => '300',
					'form_input_small_rounded'                      => 0,
					'form_input_normal_rounded'                     => 0,
					'form_textarea_rounded'                         => 0,
					'button_small_rounded'                          => 0,
					'button_rounded'                                => 0,
					'button_large_rounded'                          => 0,
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Futura',
						'font-weight'    => '300',
						'font-size'      => '16px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
					],
					'top_bar_style_01_bg_color'                     => '#000000',
					'top_bar_style_01_link_color'                   => '#fff',
					'top_bar_style_01_link_hover_color'             => 'rgba(255,255,255,0.7)',
					'header_style_navigation_typography'            => [
						'font-family'    => 'Futura',
						'font-weight'    => '500',
						'font-size'      => '14px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-supplyment'     => [
					'primary_color'                                  => '#F3BB2E',
					'typography_body'                                => [
						'font-family' => 'Poppins',
						'font-weight' => '400', // 500
						'font-size'   => '15px',
						'line-height' => '28px',
					],
					'typography_heading2'                            => [
						'font-family' => 'Rozha One',
						'font-weight' => '400',
					],
					'button_typography_custom'                       => [
						'font-size'      => '15px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'                => '600',
					'form_input_small_rounded'                       => 0,
					'form_input_normal_rounded'                      => 0,
					'form_textarea_rounded'                          => 0,
					'button_small_rounded'                           => 0,
					'button_rounded'                                 => 0,
					'button_large_rounded'                           => 0,
					'top_bar_style_01_text_typography'               => [
						'font-family'    => 'Poppins',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#2B3B5D',
						'text-transform' => '',
					],
					'top_bar_style_01_bg_color'                      => '#F3BB2E',
					'top_bar_style_01_link_color'                    => '#2B3B5D',
					'top_bar_style_01_link_hover_color'              => '#2B3B5D',
					'header_style_navigation_typography'             => [
						'font-family'    => 'Poppins',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_light_icon_badge_text_color'       => '#2B3B5D',
					'header_style_light_icon_badge_background_color' => '#F3BB2E',
					'header_style_dark_icon_badge_text_color'        => '#2B3B5D',
					'header_style_dark_icon_badge_background_color'  => '#F3BB2E',
					'header_sticky_icon_badge_text_color'            => '#2B3B5D',
					'header_sticky_icon_badge_background_color'      => '#F3BB2E',
				],
				'home-bag'            => [
					'primary_color'                                 => '#C96E15',
					'typography_heading2'                           => [
						'font-family' => 'NewYork',
						'font-weight' => '400',
					],
					'typography_heading_weight_2'                   => '500',
					'button_typography_custom'                      => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight'               => '500',
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-nail-polish'    => [
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Jost',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#000',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'top_bar_style_01_bg_color'                     => '#F8F9BD',
					'top_bar_style_01_link_color'                   => '#000',
					'top_bar_style_01_link_hover_color'             => '#000',
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-baby'           => [
					'primary_color'                    => '#E1927F',
					'form_textarea_rounded'            => 5,
					'button_rounded'                   => 23,
					'button_small_rounded'             => 20,
					'button_large_rounded'             => 25,
					'form_input_small_rounded'         => 20,
					'form_input_normal_rounded'        => 23,
					'button_background_color'          => '#E1927F',
					'button_border_color'              => '#E1927F',
					'button_hover_background_color'    => '#E1927F',
					'button_hover_border_color'        => '#E1927F',
					'top_bar_style_01_text_typography' => [
						'font-family'    => 'Jost',
						'font-weight'    => '500',
						'font-size'      => '16px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'        => '#E1927F',
				],
				'home-socks'          => [
					'typography_body'                               => [
						'font-family' => 'ClashGrotesk',
						'font-weight' => '500',
						'font-size'   => '14px',
						'line-height' => '21px',
					],
					'typography_heading'                            => [
						'font-family' => 'ClashGrotesk',
						'font-weight' => '500',
					],
					'typography_heading_weight_2'                   => '500',
					'typography_heading2'                           => [
						'font-family' => 'ClashGrotesk',
						'font-weight' => '500',
					],
					'button_typography_custom'                      => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight'               => '500',
					'form_input_small_rounded'                      => 0,
					'form_input_normal_rounded'                     => 0,
					'form_textarea_rounded'                         => 0,
					'button_small_rounded'                          => 0,
					'button_rounded'                                => 0,
					'button_large_rounded'                          => 0,
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'ClashGrotesk',
						'font-weight'    => '500',
						'font-size'      => '14px',
						'line-height'    => '26px',
						'color'          => '#000',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'top_bar_style_01_bg_color'                     => '#DEC6EB',
					'top_bar_style_01_link_color'                   => '#000',
					'top_bar_style_01_link_hover_color'             => '#000',
					'header_height'                                 => [
						'height' => 100,
						'units'  => 'px',
					],
					'header_style_navigation_typography'            => [
						'font-family'    => 'ClashGrotesk',
						'font-weight'    => '500',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-juice'          => [
					'typography_body'                 => [
						'font-family' => 'Gilroy',
						'font-weight' => '500',
						'font-size'   => '14px',
						'line-height' => '21px',
					],
					'typography_heading'              => [
						'font-family' => 'Gilroy',
						'font-weight' => '500',
					],
					'typography_heading_weight_2'     => '500',
					'typography_heading2'             => [
						'font-family' => 'Gilroy',
						'font-weight' => '500',
					],
					'button_typography_custom'        => [
						'font-size'      => '14px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight' => '600',
					'button_rounded'                  => 23,
					'button_small_rounded'            => 20,
					'button_large_rounded'            => 25,
					'form_textarea_rounded'           => 5,
					'form_input_small_rounded'        => 20,
					'form_input_normal_rounded'       => 23,
					'form_typography_inherit'         => '1',
					'form_typography_custom_weight'   => '500',

					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Gilroy',
						'font-weight'    => '500',
						'font-size'      => '14px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_navigation_typography'            => [
						'font-family'    => 'Gilroy',
						'font-weight'    => '600',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-barber'         => [
					'primary_color'                                 => '#927D5F',
					'typography_body'                               => [
						'font-family' => 'Roboto Condensed',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-family' => 'Roboto Condensed',
						'font-weight' => '700',
					],
					'typography_heading_weight_2'                   => '700',
					'button_typography_custom'                      => [
						'font-size'      => '15px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'button_typography_custom_weight'               => '700',
					'form_input_normal_rounded'                     => 0,
					'form_textarea_rounded'                         => 0,
					'button_rounded'                                => 0,
					'form_typography_inherit'                       => '1',
					'form_typography_custom_weight'                 => '400',
					'button_background_color'                       => '#927D5F',
					'button_border_color'                           => '#927D5F',
					'button_hover_background_color'                 => '#927D5F',
					'button_hover_border_color'                     => '#927D5F',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Roboto Condensed',
						'font-weight'    => '400',
						'font-size'      => '14px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_navigation_typography'            => [
						'font-family'    => 'Roboto Condensed',
						'font-weight'    => '700',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-beauty'         => [
					'typography_body'                    => [
						'font-family' => 'Satoshi',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                 => [
						'font-family' => 'Satoshi',
						'font-weight' => '700',
					],
					'typography_heading_weight_2'        => '700',
					'button_typography_custom'           => [
						'font-size'      => '15px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'    => '500',
					'form_input_normal_rounded'          => 0,
					'form_textarea_rounded'              => 0,
					'button_rounded'                     => 0,
					'form_typography_inherit'            => '1',
					'form_typography_custom_weight'      => '400',
					'top_bar_style_01_text_typography'   => [
						'font-family'    => 'Satoshi',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_navigation_typography' => [
						'font-family'    => 'Satoshi',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-mirror'         => [
					'typography_heading2'                           => [
						'font-family' => 'Butler',
						'font-weight' => '400',
					],
					'button_typography_custom'                      => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight'               => '500',
					'top_bar_style_01_bg_color'                     => '#000',
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-electronic'     => [
					'primary_color'                              => '#E02B2B',
					'button_typography_custom'                   => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight'            => '500',
					'form_input_normal_border_thickness'         => 2,
					'button_rounded'                             => 23,
					'button_small_rounded'                       => 20,
					'button_large_rounded'                       => 25,
					'form_textarea_rounded'                      => 5,
					'form_input_small_rounded'                   => 20,
					'form_input_normal_rounded'                  => 23,
					'header_style_navigation_typography'         => [
						'font-family'    => 'Jost',
						'font-weight'    => '600',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_08_info_list_secondary_enable' => '1',
					'header_style_08_language_switcher_enable'   => '0',
					'header_style_08_text_enable'                => '0',
				],
				'home-houseware'      => [
					'primary_color'                            => '#322B81',
					'typography_body'                          => [
						'font-family' => 'Gilroy',
						'font-weight' => '500',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                       => [
						'font-family' => 'Gilroy',
						'font-weight' => '700',
					],
					'typography_heading_weight_2'              => '600',
					'typography_heading2'                      => [
						'font-family' => 'Gilroy',
						'font-weight' => '700',
					],
					'button_typography_custom'                 => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight'          => '700',
					'button_text_color'                        => '#000000',
					'button_hover_text_color'                  => '#000000',
					'button_background_color'                  => '#FDF397',
					'button_border_color'                      => '#FDF397',
					'button_hover_background_color'            => '#FDF397',
					'button_hover_border_color'                => '#FDF397',
					'form_input_normal_rounded'                => 10,
					'form_textarea_rounded'                    => 5,
					'button_rounded'                           => 10,
					'form_typography_inherit'                  => '1',
					'form_typography_custom_weight'            => '600',
					'top_bar_style_01_text_typography'         => [
						'font-family'    => 'Gilroy',
						'font-weight'    => '600',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_navigation_typography'       => [
						'font-family'    => 'Gilroy',
						'font-weight'    => '600',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_dark_tag_text_color'         => '#DA664A',
					'header_style_dark_tag_bg_color'           => '#fff',
					'header_above_style_dark_background'       => array(
						'background-color' => '#F1E2D6',
					),
					'header_above_style_dark_border_color'     => '#F1E2D6',
					'header_above_style_dark_text_color'       => '#322B81',
					'header_above_style_dark_link_color'       => '#000000',
					'header_above_style_dark_link_hover_color' => '#000000',
					'header_style_01_search_enable'            => 'inline',
				],
				'home-book'           => [
					'typography_heading2'             => [
						'font-family' => 'Butler',
						'font-weight' => '400',
					],
					'button_typography_custom'        => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight' => '500',
				],
				'home-hat'            => [
					'typography_body'                                => [
						'font-family' => 'Poppins',
						'font-weight' => '500',
						'font-size'   => '15px',
						'line-height' => '28px',
					],
					'typography_heading'                             => [
						'font-family'    => 'Poppins',
						'font-weight'    => '700',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom'                       => [
						'text-transform' => 'uppercase',
						'font-size'      => '14px',
						'letter-spacing' => '0.5px',
					],
					'button_typography_custom_weight'                => '700',
					'button_rounded'                                 => 0,
					'button_small_rounded'                           => 0,
					'button_large_rounded'                           => 0,
					'form_input_normal_rounded'                      => 0,
					'form_input_small_rounded'                       => 0,
					'form_textarea_rounded'                          => 0,
					'top_bar_style_01_text_typography'               => [
						'font-family'    => 'Poppins',
						'font-weight'    => '500',
						'font-size'      => '14px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'                      => '#000',
					'top_bar_style_01_link_color'                    => '#fff',
					'top_bar_style_01_link_hover_color'              => 'rgba(255,255,255,0.7)',
					'header_style_navigation_typography'             => [
						'font-family'    => 'Poppins',
						'font-weight'    => '700',
						'font-size'      => '14px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'header_style_light_icon_badge_text_color'       => '#fff',
					'header_style_light_icon_badge_background_color' => '#000',
					'header_style_dark_icon_badge_text_color'        => '#fff',
					'header_style_dark_icon_badge_background_color'  => '#000',
					'header_sticky_icon_badge_text_color'            => '#fff',
					'header_sticky_icon_badge_background_color'      => '#000',
				],
				'home-hand-santizer'  => [
					'body_color'                                    => '#7E7E7E',
					'primary_color'                                 => '#549263',
					'typography_body'                               => [
						'font-family' => 'Gilroy',
						'font-weight' => '500',
						'font-size'   => '16px',
						'line-height' => '26px',
					],
					'typography_heading'                            => [
						'font-family' => 'Gilroy',
						'font-weight' => '600',
					],
					'typography_heading_weight_2'                   => '600',
					'typography_heading2'                           => [
						'font-family' => 'Gilroy',
						'font-weight' => '600',
					],
					'button_typography_custom'                      => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight'               => '700',
					'form_input_normal_rounded'                     => 12,
					'form_textarea_rounded'                         => 5,
					'button_rounded'                                => 12,
					'form_typography_inherit'                       => '1',
					'form_typography_custom_weight'                 => '500',
					'button_background_color'                       => '#549263',
					'button_border_color'                           => '#549263',
					'button_hover_background_color'                 => '#549263',
					'button_hover_border_color'                     => '#549263',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Jost',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#000',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'                     => '#C8D8CE',
					'top_bar_style_01_link_color'                   => '#000',
					'top_bar_style_01_link_hover_color'             => '#000',
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-bathroom'       => [
					'typography_body'                               => [
						'font-family' => 'Gordita',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '30px',
					],
					'typography_heading'                            => [
						'font-family' => 'Gordita',
						'font-weight' => '500',
					],
					'typography_heading_weight_2'                   => '500',
					'typography_heading2'                           => [
						'font-family' => 'Gordita',
						'font-weight' => '500',
					],
					'button_typography_custom'                      => [
						'font-size'      => '14px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '0.7px',
					],
					'button_typography_custom_weight'               => '500',
					'form_input_normal_rounded'                     => 0,
					'form_input_small_rounded'                      => 0,
					'form_textarea_rounded'                         => 0,
					'button_rounded'                                => 0,
					'button_small_rounded'                          => 0,
					'button_large_rounded'                          => 0,
					'form_typography_inherit'                       => '1',
					'form_typography_custom_weight'                 => '400',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Gordita',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_navigation_typography'            => [
						'font-family'    => 'Gordita',
						'font-weight'    => '500',
						'font-size'      => '14px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-skincare'       => [
					'primary_color'                     => '#332D55',
					'typography_body'                   => [
						'font-family' => 'Poppins',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading2'               => [
						'font-family' => 'Butler',
						'font-weight' => '500',
					],
					'typography_heading_weight_2'       => '500',
					'button_background_color'           => '#332D55',
					'button_border_color'               => '#332D55',
					'button_hover_background_color'     => '#332D55',
					'button_hover_border_color'         => '#332D55',
					'form_input_normal_rounded'         => 10,
					'form_textarea_rounded'             => 5,
					'button_rounded'                    => 10,
					'top_bar_style_01_text_typography'  => [
						'font-family'    => 'Jost',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#332D55',
						'text-transform' => 'uppercase',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'         => '#E4EFE8',
					'top_bar_style_01_link_color'       => '#332D55',
					'top_bar_style_01_link_hover_color' => '#332D55',
					'header_style_01_search_enable'     => 'inline',
					'header_height'                     => [
						'height' => 90,
						'units'  => 'px',
					],
				],
				'home-candles'        => [
					'primary_color'                                 => '#F58448',
					'typography_body'                               => [
						'font-family' => 'Poppins',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading2'                           => [
						'font-family' => 'Marcellus',
						'font-weight' => '500',
					],
					'typography_heading_weight_2'                   => '500',
					'button_rounded'                                => 23,
					'button_small_rounded'                          => 20,
					'button_large_rounded'                          => 25,
					'form_textarea_rounded'                         => 5,
					'form_input_small_rounded'                      => 20,
					'form_input_normal_rounded'                     => 23,
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Jost',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#C97755',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'top_bar_style_01_bg_color'                     => '#F7E9E3',
					'top_bar_style_01_link_color'                   => '#C97755',
					'top_bar_style_01_link_hover_color'             => '#C97755',
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-organic'        => [
					'primary_color'                                 => '#FFDD86',
					'heading_color'                                 => '#0F4226',
					'typography_body'                               => [
						'font-family' => 'Raleway',
						'font-weight' => '500',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-family' => 'Raleway',
						'font-weight' => '700',
					],
					'typography_heading_weight_2'                   => '700',
					'typography_heading2'                           => [
						'font-family' => 'Raleway',
						'font-weight' => '700',
					],
					'button_typography_custom'                      => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight'               => '700',
					'button_rounded'                                => 23,
					'button_small_rounded'                          => 20,
					'button_large_rounded'                          => 25,
					'form_textarea_rounded'                         => 5,
					'form_input_small_rounded'                      => 20,
					'form_input_normal_rounded'                     => 23,
					'form_typography_inherit'                       => '1',
					'form_typography_custom_weight'                 => '500',
					'button_text_color'                             => '#0F4226',
					'button_background_color'                       => '#FFFFFF',
					'button_border_color'                           => '#C4C4C4',
					'button_hover_text_color'                       => '#FFFFFF',
					'button_hover_background_color'                 => '#0F4226',
					'button_hover_border_color'                     => '#0F4226',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Raleway',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_navigation_typography'            => [
						'font-family'    => 'Raleway',
						'font-weight'    => '700',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_dark_text_color'                  => '#000',
					'header_style_dark_icon_badge_text_color'       => '#0F4226',
					'header_style_dark_icon_badge_background_color' => '#FFDD86',
					'header_sticky_icon_badge_text_color'           => '#0F4226',
					'header_sticky_icon_badge_background_color'     => '#FFDD86',
				],
				'home-pet'            => [
					'primary_color'                   => '#5EA274',
					'heading_color'                   => '#0F4226',
					'typography_body'                 => [
						'font-family' => 'Open Sans',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'              => [
						'font-family' => 'Jellee',
						'font-weight' => '700',
					],
					'typography_heading_weight_2'     => '700',
					'typography_heading2'             => [
						'font-family' => 'Jellee',
						'font-weight' => '700',
					],
					'button_typography_custom'        => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight' => '700',
					'button_rounded'                  => 23,
					'button_small_rounded'            => 20,
					'button_large_rounded'            => 25,
					'form_textarea_rounded'           => 5,
					'form_input_small_rounded'        => 20,
					'form_input_normal_rounded'       => 23,
					'form_typography_inherit'         => '1',
					'form_typography_custom_weight'   => '400',
					'button_text_color'               => '#FFFFFF',
					'button_hover_text_color'         => '#FFFFFF',
					'button_background_color'         => '#5EA274',
					'button_border_color'             => '#5EA274',
					'button_hover_background_color'   => '#5EA274',
					'button_hover_border_color'       => '#5EA274',

					'top_bar_style_01_text_typography'   => [
						'font-family'    => 'Open Sans',
						'font-weight'    => '600',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#0F4226',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'          => '#EEED6B',
					'top_bar_style_01_link_color'        => '#0F4226',
					'top_bar_style_01_link_hover_color'  => '#0F4226',
					'header_style_navigation_typography' => [
						'font-family'    => 'Open Sans',
						'font-weight'    => '700',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_dark_text_color'       => '#000',
				],
				'home-pan'            => [
					'primary_color'                      => '#DC6545',
					'typography_body'                    => [
						'font-family' => 'Rubik',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                 => [
						'font-family' => 'Sentient',
						'font-weight' => '400',
					],
					'typography_heading_weight_2'        => '400',
					'typography_heading2'                => [
						'font-family' => 'Sentient',
						'font-weight' => '400',
					],
					'button_typography_custom'           => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight'    => '400',
					'form_input_normal_rounded'          => 0,
					'form_textarea_rounded'              => 0,
					'button_rounded'                     => 0,
					'form_typography_inherit'            => '1',
					'form_typography_custom_weight'      => '400',
					'button_text_color'                  => '#FFFFFF',
					'button_hover_text_color'            => '#FFFFFF',
					'button_background_color'            => '#DC6545',
					'button_border_color'                => '#DC6545',
					'button_hover_background_color'      => '#DC6545',
					'button_hover_border_color'          => '#DC6545',
					'top_bar_style_01_text_typography'   => [
						'font-family'    => 'Rubik',
						'font-weight'    => '400',
						'font-size'      => '16px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'          => '#DC6545',
					'header_style_navigation_typography' => [
						'font-family'    => 'Rubik',
						'font-weight'    => '400',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => '',
						'letter-spacing' => '',
					],
				],
				'home-paint'          => [
					'typography_body'                               => [
						'font-family' => 'Satoshi',
						'font-weight' => '500',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-weight' => '700',
					],
					'typography_heading_weight_2'                   => '700',
					'typography_heading2'                           => [
						'font-family' => 'Lora',
						'font-weight' => '400',
					],
					'button_typography_custom'                      => [
						'font-size'      => '14px',
						'letter-spacing' => '1px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'               => '700',
					'button_rounded'                                => 23,
					'button_small_rounded'                          => 20,
					'button_large_rounded'                          => 25,
					'form_textarea_rounded'                         => 5,
					'form_input_small_rounded'                      => 20,
					'form_input_normal_rounded'                     => 23,
					'form_typography_inherit'                       => '1',
					'form_typography_custom_weight'                 => '500',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Satoshi',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#000000',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'                     => '#D2E4E4',
					'top_bar_style_01_link_color'                   => '#000000',
					'top_bar_style_01_link_hover_color'             => '#000000',
					'header_style_navigation_typography'            => [
						'font-family'    => 'Satoshi',
						'font-weight'    => '700',
						'font-size'      => '14px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'header_style_dark_text_color'                  => '#000',
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-pod'            => [
					'typography_body'                              => [
						'font-family' => 'Outfit',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                           => [
						'font-weight' => '400',
					],
					'typography_heading_weight_2'                  => '500',
					'typography_heading2'                          => [
						'font-family'    => 'Anton',
						'font-weight'    => '400',
						'letter-spacing' => '1px',
					],
					'button_typography_custom'                     => [
						'font-size'      => '15px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'              => '600',
					'form_border_color'                            => '#fff',
					'form_box_shadow'                              => '0 0 20px rgba(0, 0, 0, 0.12)',
					'form_input_normal_rounded'                    => 0,
					'form_textarea_rounded'                        => 0,
					'button_rounded'                               => 0,
					'form_typography_inherit'                      => '1',
					'form_typography_custom_weight'                => '400',
					'global_top_bar'                               => 'none',
					'top_bar_style_01_text_typography'             => [
						'font-family'    => 'Outfit',
						'font-weight'    => '500',
						'font-size'      => '16px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_navigation_typography'           => [
						'font-family'    => 'Outfit',
						'font-weight'    => '600',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '',
					],
					'header_above_style_dark_background'           => array(
						'background-color' => '#000',
					),
					'header_above_style_dark_border_color'         => 'rgba(0,0,0,0)',
					'header_above_style_dark_item_separator_color' => '#fff',
					'header_above_style_dark_text_color'           => '#fff',
					'header_above_style_dark_link_color'           => '#fff',
					'header_above_style_dark_link_hover_color'     => 'rgba(255,255,255,0.7)',
					'header_search_form_style'                     => 'button-fill',
				],
				'home-gym-supplyment' => [
					'primary_color'                                  => '#ECFF12',
					'typography_body'                                => [
						'font-family' => 'Roboto',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                             => [
						'font-family' => 'Teko',
						'font-weight' => '700',
					],
					'typography_heading_weight_2'                    => '700',
					'typography_heading2'                            => [
						'font-family' => 'Teko',
						'font-weight' => '700',
					],
					'button_typography_custom'                       => [
						'font-size'      => '16px',
						'letter-spacing' => '1px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'                => '700',
					'form_input_normal_rounded'                      => 0,
					'form_textarea_rounded'                          => 0,
					'button_rounded'                                 => 0,
					'form_typography_inherit'                        => '1',
					'form_typography_custom_weight'                  => '400',
					'button_text_color'                              => '#000000',
					'button_hover_text_color'                        => '#000000',
					'button_background_color'                        => '#ECFF12',
					'button_border_color'                            => '#ECFF12',
					'button_hover_background_color'                  => '#ECFF12',
					'button_hover_border_color'                      => '#ECFF12',
					'global_top_bar'                                 => 'none',
					'top_bar_style_01_text_typography'               => [
						'font-family'    => 'Roboto',
						'font-weight'    => '400',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#000000',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'                      => '#ECFF12',
					'top_bar_style_01_link_color'                    => '#000000',
					'top_bar_style_01_link_hover_color'              => '#000000',
					'header_style_navigation_typography'             => [
						'font-family'    => 'Roboto',
						'font-weight'    => '700',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'header_style_dark_text_color'                   => '#000',
					'header_style_dark_icon_badge_text_color'        => '#000000',
					'header_style_dark_icon_badge_background_color'  => '#ECFF12',
					'header_style_light_icon_badge_text_color'       => '#000000',
					'header_style_light_icon_badge_background_color' => '#ECFF12',
					'header_sticky_icon_badge_text_color'            => '#000000',
					'header_sticky_icon_badge_background_color'      => '#ECFF12',
				],
				'home-speaker'        => [
					'typography_body'                    => [
						'font-family' => 'Gilroy',
						'font-weight' => '500',
						'font-size'   => '16px',
						'line-height' => '26px',
					],
					'typography_heading'                 => [
						'font-family' => 'Gilroy',
						'font-weight' => '600',
					],
					'typography_heading_weight_2'        => '500',
					'typography_heading2'                => [
						'font-family' => 'Gilroy',
						'font-weight' => '600',
					],
					'button_typography_custom'           => [
						'font-size'      => '15px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'    => '600',
					'button_rounded'                     => 23,
					'button_small_rounded'               => 20,
					'button_large_rounded'               => 25,
					'form_textarea_rounded'              => 5,
					'form_input_small_rounded'           => 20,
					'form_input_normal_rounded'          => 23,
					'form_typography_inherit'            => '1',
					'form_typography_custom_weight'      => '500',
					'header_style_navigation_typography' => [
						'font-family'    => 'Gilroy',
						'font-weight'    => '600',
						'font-size'      => '15px',
						'line-height'    => '19px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '',
					],
				],
				'home-postcard'       => [
					'primary_color'                   => '#212806',
					'heading_color'                   => '#212806',
					'typography_body'                 => [
						'font-family' => 'Poppins',
						'font-weight' => '400',
						'font-size'   => '15px',
						'line-height' => '24px',
					],
					'typography_heading'              => [
						'font-family' => 'Butler',
						'font-weight' => '400',
					],
					'typography_heading_weight_2'     => '400',
					'typography_heading2'             => [
						'font-family' => 'Butler',
						'font-weight' => '400',
					],
					'button_typography_custom'        => [
						'font-size'      => '15px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight' => '500',
					'button_rounded'                  => 23,
					'button_small_rounded'            => 20,
					'button_large_rounded'            => 25,
					'form_textarea_rounded'           => 5,
					'form_input_small_rounded'        => 20,
					'form_input_normal_rounded'       => 23,
					'form_typography_inherit'         => '1',
					'form_typography_custom_weight'   => '400',
					'button_text_color'               => '#ffffff',
					'button_hover_text_color'         => '#ffffff',
					'button_background_color'         => '#212806',
					'button_border_color'             => '#212806',
					'button_hover_background_color'   => '#212806',
					'button_hover_border_color'       => '#212806',
				],
				'home-christmas'      => [
					'primary_color'                   => '#C02C30',
					'typography_body'                 => [
						'font-family' => 'Jost',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'              => [
						'font-family' => 'Sentient',
						'font-weight' => '400',
					],
					'typography_heading_weight_2'     => '500',
					'typography_heading2'             => [
						'font-family' => 'Jost',
						'font-weight' => '500',
					],
					'button_typography_custom'        => [
						'font-size' => '16px',
					],
					'button_typography_custom_weight' => '500',
					'form_input_normal_rounded'       => 5,
					'form_textarea_rounded'           => 5,
					'button_rounded'                  => 5,
					'form_typography_inherit'         => '1',
					'form_typography_custom_weight'   => '400',
					'button_text_color'               => '#ffffff',
					'button_hover_text_color'         => '#ffffff',
					'button_background_color'         => '#000000',
					'button_border_color'             => '#000000',
					'button_hover_background_color'   => '#000000',
					'button_hover_border_color'       => '#000000',
					'top_bar_style_01_bg_color'       => '#255840',
				],
				'home-bfcm'           => [
					'primary_color'                      => '#C02C30',
					'typography_body'                    => [
						'font-family' => 'Be Vietnam Pro',
						'font-weight' => '500',
						'font-size'   => '15px',
						'line-height' => '26px',
					],
					'typography_heading'                 => [
						'font-family' => 'Be Vietnam Pro',
						'font-weight' => '700',
					],
					'typography_heading_weight_2'        => '700',
					'typography_heading2'                => [
						'font-family' => 'Be Vietnam Pro',
						'font-weight' => '700',
					],
					'button_typography_custom'           => [
						'font-size'      => '14px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'    => '700',
					'button_rounded'                     => 23,
					'button_small_rounded'               => 20,
					'button_large_rounded'               => 25,
					'form_textarea_rounded'              => 5,
					'form_input_small_rounded'           => 20,
					'form_input_normal_rounded'          => 23,
					'form_typography_inherit'            => '1',
					'form_typography_custom_weight'      => '700',
					'button_text_color'                  => '#ffffff',
					'button_hover_text_color'            => '#ffffff',
					'button_background_color'            => '#000000',
					'button_border_color'                => '#000000',
					'button_hover_background_color'      => '#000000',
					'button_hover_border_color'          => '#000000',
					'header_style_navigation_typography' => [
						'font-family'    => 'Be Vietnam Pro',
						'font-weight'    => '700',
						'font-size'      => '14px',
						'line-height'    => '18px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
				],
				'home-surfboard'      => [
					'primary_color'                                 => '#ECE770',
					'typography_body'                               => [
						'font-family' => 'Syne',
						'font-weight' => '500',
						'font-size'   => '16px',
						'line-height' => '26px',
					],
					'typography_heading'                            => [
						'font-family'    => 'Syne',
						'font-weight'    => '700',
						'letter-spacing' => '1px',
						'text-transform' => 'uppercase',
					],
					'typography_heading_weight_2'                   => '500',
					'button_typography_custom'                      => [
						'font-size'      => '15px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'               => '700',
					'form_input_normal_rounded'                     => 0,
					'form_textarea_rounded'                         => 0,
					'button_rounded'                                => 0,
					'form_typography_inherit'                       => '1',
					'form_typography_custom_weight'                 => '500',
					'global_top_bar'                                => 'none',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Syne',
						'font-weight'    => '500',
						'font-size'      => '16px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_navigation_typography'            => [
						'font-family'    => 'Syne',
						'font-weight'    => '700',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'header_above_style_dark_background'            => array(
						'background-color' => '#000',
					),
					'header_above_style_dark_border_color'          => 'rgba(0,0,0,0)',
					'header_above_style_dark_item_separator_color'  => '#fff',
					'header_above_style_dark_text_color'            => '#fff',
					'header_above_style_dark_link_color'            => '#fff',
					'header_above_style_dark_link_hover_color'      => 'rgba(255,255,255,0.7)',
					'header_style_light_text_color'                 => '#fff',
					'header_style_01_info_list_enable'              => '0',
					'header_style_01_language_switcher_enable'      => '0',
					'header_style_dark_icon_badge_text_color'       => '#000000',
					'header_style_dark_icon_badge_background_color' => '#ECE770',
					'header_sticky_icon_badge_text_color'           => '#000000',
					'header_sticky_icon_badge_background_color'     => '#ECE770',
				],
				'home-bike'           => [
					'primary_color'                                 => '#B23B21',
					'typography_body'                               => [
						'font-family' => 'BespokeSerif',
						'font-weight' => '400',
						'font-size'   => '15px',
						'line-height' => '26px',
					],
					'typography_heading'                            => [
						'font-family' => 'BespokeSerif',
						'font-weight' => '500',
					],
					'typography_heading_weight_2'                   => '500',
					'button_typography_custom'                      => [
						'font-size'      => '14px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'               => '500',
					'button_rounded'                                => 23,
					'button_small_rounded'                          => 20,
					'button_large_rounded'                          => 25,
					'form_textarea_rounded'                         => 5,
					'form_input_small_rounded'                      => 20,
					'form_input_normal_rounded'                     => 23,
					'button_text_color'                             => '#ffffff',
					'button_hover_text_color'                       => '#ffffff',
					'button_background_color'                       => '#B23B21',
					'button_border_color'                           => '#B23B21',
					'button_hover_background_color'                 => '#B23B21',
					'button_hover_border_color'                     => '#B23B21',
					'form_typography_inherit'                       => '1',
					'form_typography_custom_weight'                 => '400',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'BespokeSerif',
						'font-weight'    => '400',
						'font-style'     => 'italic',
						'font-size'      => '14px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'                     => '#42565A',
					'header_style_navigation_typography'            => [
						'font-family'    => 'BespokeSerif',
						'font-weight'    => '500',
						'font-size'      => '14px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'header_above_style_dark_background'            => array(
						'background-color' => '#000',
					),
					'header_above_style_dark_border_color'          => 'rgba(0,0,0,0)',
					'header_above_style_dark_item_separator_color'  => '#fff',
					'header_above_style_dark_text_color'            => '#fff',
					'header_above_style_dark_link_color'            => '#fff',
					'header_above_style_dark_link_hover_color'      => 'rgba(255,255,255,0.7)',
					'header_style_light_text_color'                 => '#fff',
					'global_header'                                 => '03',
					'header_style_01_info_list_enable'              => '0',
					'header_style_01_language_switcher_enable'      => '0',
					'header_style_01_header_above_enable'           => '0',
					'header_style_03_info_list_enable'              => '0',
					'header_style_03_language_switcher_enable'      => '0',
					'header_style_03_header_above_enable'           => '0',
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#B23B21',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#B23B21',
				],
				'home-ceramic'        => [
					'primary_color'                                 => '#B23B21',
					'typography_body'                               => [
						'font-family' => 'GeneralSans',
						'font-weight' => '500',
						'font-size'   => '16px',
						'line-height' => '26px',
					],
					'typography_heading'                            => [
						'font-family' => 'Butler',
						'font-weight' => '500',
					],
					'typography_heading_weight_2'                   => '500',
					'button_typography_custom'                      => [
						'font-size'      => '15px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1.5px',
					],
					'button_typography_custom_weight'               => '500',
					'button_rounded'                                => 0,
					'button_small_rounded'                          => 0,
					'button_large_rounded'                          => 0,
					'form_textarea_rounded'                         => 0,
					'form_input_small_rounded'                      => 0,
					'form_input_normal_rounded'                     => 0,
					'form_typography_inherit'                       => '1',
					'form_typography_custom_weight'                 => '500',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'GeneralSans',
						'font-weight'    => '500',
						'font-size'      => '14px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => 'uppercase',
						'letter-spacing' => '2px',
					],
					'top_bar_style_01_bg_color'                     => '#222222',
					'header_style_navigation_typography'            => [
						'font-family'    => 'GeneralSans',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1.5px',
					],
					'header_above_style_dark_background'            => array(
						'background-color' => '#000',
					),
					'header_above_style_dark_border_color'          => 'rgba(0,0,0,0)',
					'header_above_style_dark_item_separator_color'  => '#fff',
					'header_above_style_dark_text_color'            => '#fff',
					'header_above_style_dark_link_color'            => '#fff',
					'header_above_style_dark_link_hover_color'      => 'rgba(255,255,255,0.7)',
					'header_style_light_text_color'                 => '#fff',
					'global_header'                                 => '03',
					'header_style_01_info_list_enable'              => '0',
					'header_style_01_language_switcher_enable'      => '0',
					'header_style_01_header_above_enable'           => '0',
					'header_style_03_info_list_enable'              => '0',
					'header_style_03_language_switcher_enable'      => '0',
					'header_style_03_header_above_enable'           => '0',
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-camping'        => [
					'primary_color'                                  => '#B64708',
					'heading_color'                                  => '#383531',
					'button_text_color'                              => '#ffffff',
					'button_hover_text_color'                        => '#ffffff',
					'button_background_color'                        => '#383531',
					'button_border_color'                            => '#383531',
					'button_hover_background_color'                  => '#383531',
					'button_hover_border_color'                      => '#383531',
					'button2_text_color'                             => '#383531',
					'button2_background_color'                       => 'rgba(0,0,0,0)',
					'button2_border_color'                           => '#dcdcdc',
					'button2_hover_text_color'                       => '#fff',
					'button2_hover_background_color'                 => '#383531',
					'button2_hover_border_color'                     => '#383531',
					'form_text_color'                                => '#383531',
					'form_background_color'                          => '#fff',
					'form_border_color'                              => '#dcdcdc',
					'form_focus_text_color'                          => '#383531',
					'form_focus_background_color'                    => '#fff',
					'form_focus_border_color'                        => '#383531',
					'typography_body'                                => [
						'font-family' => 'Roboto Slab',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                             => [
						'font-family' => 'Roboto Slab',
						'font-weight' => '500',
					],
					'typography_heading_weight_2'                    => '400',
					'button_typography_custom'                       => [
						'font-size'      => '15px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '0.75px',
					],
					'button_typography_custom_weight'                => '500',
					'button_rounded'                                 => 0,
					'button_small_rounded'                           => 0,
					'button_large_rounded'                           => 0,
					'form_textarea_rounded'                          => 0,
					'form_input_small_rounded'                       => 0,
					'form_input_normal_rounded'                      => 0,
					'form_typography_inherit'                        => '1',
					'form_typography_custom_weight'                  => '500',
					'top_bar_style_01_text_typography'               => [
						'font-family'    => 'Roboto Slab',
						'font-weight'    => '500',
						'font-size'      => '14px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => 'none',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'                      => '#383531',
					'header_style_navigation_typography'             => [
						'font-family'    => 'Roboto Slab',
						'font-weight'    => '400',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => 'none',
						'letter-spacing' => '',
					],
					'header_above_style_dark_background'             => array(
						'background-color' => '#000',
					),
					'header_above_style_dark_border_color'           => 'rgba(0,0,0,0)',
					'header_above_style_dark_item_separator_color'   => '#fff',
					'header_above_style_dark_text_color'             => '#fff',
					'header_above_style_dark_link_color'             => '#fff',
					'header_above_style_dark_link_hover_color'       => 'rgba(255,255,255,0.7)',
					'header_style_light_text_color'                  => '#fff',
					'header_style_01_info_list_enable'               => '0',
					'header_style_01_language_switcher_enable'       => '0',
					'header_style_01_header_above_enable'            => '0',
					'header_style_dark_icon_badge_text_color'        => '#fff',
					'header_style_dark_icon_badge_background_color'  => '#B64708',
					'header_sticky_icon_badge_text_color'            => '#fff',
					'header_sticky_icon_badge_background_color'      => '#B64708',
					'header_style_light_icon_badge_text_color'       => '#fff',
					'header_style_light_icon_badge_background_color' => '#B64708',
					'header_height'                                  => [
						'height' => 92,
						'units'  => 'px',
					],
				],
				'home-cake'           => [
					'primary_color'                                 => '#E34875',
					'heading_color'                                 => '#6D4F4F',
					'button_text_color'                             => '#ffffff',
					'button_hover_text_color'                       => '#ffffff',
					'button_background_color'                       => '#E34875',
					'button_border_color'                           => '#E34875',
					'button_hover_background_color'                 => '#E34875',
					'button_hover_border_color'                     => '#E34875',
					'button2_text_color'                            => '#E34875',
					'button2_background_color'                      => 'rgba(0,0,0,0)',
					'button2_border_color'                          => '#dcdcdc',
					'button2_hover_text_color'                      => '#fff',
					'button2_hover_background_color'                => '#E34875',
					'button2_hover_border_color'                    => '#E34875',
					'form_text_color'                               => '#6D4F4F',
					'form_background_color'                         => '#fff',
					'form_border_color'                             => '#dcdcdc',
					'form_focus_text_color'                         => '#6D4F4F',
					'form_focus_background_color'                   => '#fff',
					'form_focus_border_color'                       => '#6D4F4F',
					'typography_body'                               => [
						'font-family' => 'Gilroy',
						'font-weight' => '500',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-family' => 'Gilroy',
						'font-weight' => '700',
					],
					'typography_heading_weight_2'                   => '500',
					'typography_heading2'                           => [
						'font-family' => 'Jellee',
						'font-weight' => '700',
					],
					'button_typography_custom'                      => [
						'font-size'      => '16px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'               => '700',
					'button_rounded'                                => 10,
					'button_small_rounded'                          => 5,
					'button_large_rounded'                          => 10,
					'form_textarea_rounded'                         => 5,
					'form_input_small_rounded'                      => 5,
					'form_input_normal_rounded'                     => 10,
					'form_typography_inherit'                       => '1',
					'form_typography_custom_weight'                 => '500',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Gilroy',
						'font-weight'    => '700',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => 'none',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'                     => '#6D4F4F',
					'header_style_navigation_typography'            => [
						'font-family'    => 'Gilroy',
						'font-weight'    => '700',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => 'none',
						'letter-spacing' => '',
					],
					'header_above_style_dark_background'            => array(
						'background-color' => '#000',
					),
					'header_above_style_dark_border_color'          => 'rgba(0,0,0,0)',
					'header_above_style_dark_item_separator_color'  => '#fff',
					'header_above_style_dark_text_color'            => '#fff',
					'header_above_style_dark_link_color'            => '#fff',
					'header_above_style_dark_link_hover_color'      => 'rgba(255,255,255,0.7)',
					'header_style_light_text_color'                 => '#fff',
					'header_style_dark_text_color'                  => '#6D4F4F',
					'header_style_dark_link_color'                  => '#6D4F4F',
					'header_style_dark_nav_link_color'              => '#6D4F4F',
					'header_style_dark_nav_link_hover_color'        => '#E34875',
					'global_header'                                 => '03',
					'header_style_01_info_list_enable'              => '0',
					'header_style_01_language_switcher_enable'      => '0',
					'header_style_01_header_above_enable'           => '0',
					'header_style_03_info_list_enable'              => '0',
					'header_style_03_language_switcher_enable'      => '0',
					'header_style_03_header_above_enable'           => '0',
					'header_style_dark_icon_color'                  => '#6D4F4F',
					'header_style_dark_icon_hover_color'            => '#E34875',
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#E34875',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#E34875',
					'header_height'                                 => [
						'height' => 80,
						'units'  => 'px',
					],
				],
				'home-soap'           => [
					'typography_body'                               => [
						'font-family' => 'Outfit',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-family' => 'Outfit',
						'font-weight' => '400',
					],
					'typography_heading_weight_2'                   => '500',
					'button_typography_custom'                      => [
						'font-size'      => '14px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'button_typography_custom_weight'               => '500',
					'button_rounded'                                => 23,
					'button_small_rounded'                          => 20,
					'button_large_rounded'                          => 25,
					'form_textarea_rounded'                         => 5,
					'form_input_small_rounded'                      => 20,
					'form_input_normal_rounded'                     => 23,
					'form_typography_inherit'                       => '1',
					'form_typography_custom_weight'                 => '400',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Outfit',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'global_top_bar'                                => 'none',
					'top_bar_style_01_bg_color'                     => '#000',
					'header_style_navigation_typography'            => [
						'font-family'    => 'Outfit',
						'font-weight'    => '500',
						'font-size'      => '14px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'header_above_style_dark_background'            => array(
						'background-color' => '#000',
					),
					'header_above_style_dark_border_color'          => 'rgba(0,0,0,0)',
					'header_above_style_dark_item_separator_color'  => '#fff',
					'header_above_style_dark_text_color'            => '#fff',
					'header_above_style_dark_link_color'            => '#fff',
					'header_above_style_dark_link_hover_color'      => 'rgba(255,255,255,0.7)',
					'header_style_light_text_color'                 => '#fff',
					'header_style_01_info_list_enable'              => '0',
					'header_style_01_language_switcher_enable'      => '0',
					'header_style_01_header_above_enable'           => '0',
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-floral'         => [
					'primary_color'                                 => '#823443',
					'button_text_color'                             => '#823443',
					'button_hover_text_color'                       => '#823443',
					'button_background_color'                       => '#FDECF0',
					'button_border_color'                           => '#FDECF0',
					'button_hover_background_color'                 => '#FDECF0',
					'button_hover_border_color'                     => '#FDECF0',
					'typography_body'                               => [
						'font-family' => 'Roboto',
						'font-weight' => '400',
						'font-size'   => '15px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-family' => 'Playfair Display',
						'font-weight' => '400',
					],
					'typography_heading_weight_2'                   => '500',
					'button_typography_custom'                      => [
						'font-size'      => '15px',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'               => '500',
					'button_rounded'                                => 0,
					'button_small_rounded'                          => 0,
					'button_large_rounded'                          => 0,
					'form_textarea_rounded'                         => 0,
					'form_input_small_rounded'                      => 0,
					'form_input_normal_rounded'                     => 0,
					'form_typography_inherit'                       => '1',
					'form_typography_custom_weight'                 => '500',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Roboto',
						'font-weight'    => '400',
						'font-size'      => '14px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'top_bar_style_01_bg_color'                     => '#823443',
					'header_style_navigation_typography'            => [
						'font-family'    => 'Roboto',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '',
					],
					'header_above_style_dark_background'            => array(
						'background-color' => '#000',
					),
					'header_above_style_dark_border_color'          => 'rgba(0,0,0,0)',
					'header_above_style_dark_item_separator_color'  => '#fff',
					'header_above_style_dark_text_color'            => '#fff',
					'header_above_style_dark_link_color'            => '#fff',
					'header_above_style_dark_link_hover_color'      => 'rgba(255,255,255,0.7)',
					'header_style_light_text_color'                 => '#fff',
					'global_header'                                 => '09',
					'header_style_09_content_width'                 => Minimog_Site_Layout::CONTAINER_LARGE,
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#823443',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#823443',
					'header_search_form_style'                      => 'thick-bottom-line',
					'header_below_style_dark_inner_border'          => [
						'border-color'  => '#eee',
						'border-style'  => 'solid',
						'border-top'    => '1px',
						'border-right'  => '',
						'border-bottom' => '',
						'border-left'   => '',
					],
					'header_icons_style'                            => 'icon-set-02',
					'header_cart_icon_style'                        => 'icon-set-02',
				],
				'home-smart-light'    => [
					'body_color'                                    => '#19345C',
					'link_color'                                    => '#19345C',
					'link_hover_color'                              => '#FFC1A7',
					'heading_color'                                 => '#19345C',
					'button_text_color'                             => '#19345C',
					'button_hover_text_color'                       => '#ffffff',
					'button_background_color'                       => '#FFC1A7',
					'button_border_color'                           => '#FFC1A7',
					'button_hover_background_color'                 => '#19345C',
					'button_hover_border_color'                     => '#19345C',
					'typography_body'                               => [
						'font-family' => 'Satoshi',
						'font-weight' => '500',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-weight' => '700',
					],
					'typography_heading_weight_2'                   => '700',
					'button_typography_custom'                      => [
						'font-size'      => '15px',
						'letter-spacing' => '0',
						'text-transform' => 'uppercase',
					],
					'button_typography_custom_weight'               => '700',
					'button_rounded'                                => 5,
					'button_small_rounded'                          => 5,
					'button_large_rounded'                          => 5,
					'form_textarea_rounded'                         => 5,
					'form_input_small_rounded'                      => 5,
					'form_input_normal_rounded'                     => 5,
					'form_typography_inherit'                       => '1',
					'form_typography_custom_weight'                 => '500',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Satoshi',
						'font-weight'    => '700',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#19345C',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'                     => '#E9F1FB',
					'top_bar_style_01_link_color'                   => '#19345C',
					'top_bar_style_01_link_hover_color'             => '#FFC1A7',
					'global_header'                                 => '03',
					'header_style_navigation_typography'            => [
						'font-family'    => 'Satoshi',
						'font-weight'    => '700',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '0',
					],
					'header_style_dark_text_color'                  => '#19345C',
					'header_style_dark_icon_badge_text_color'       => '#19345C',
					'header_style_dark_icon_badge_background_color' => '#FFC1A7',
					'header_sticky_icon_badge_text_color'           => '#19345C',
					'header_sticky_icon_badge_background_color'     => '#FFC1A7',
					'header_style_dark_nav_link_color'              => '#19345C',
					'header_style_dark_nav_link_hover_color'        => '#FFC1A7',
					'header_style_dark_icon_color'                  => '#19345C',
					'header_style_dark_icon_hover_color'            => '#FFC1A7',
					'header_style_dark_nav_line_color'              => '#FFC1A7',
					'header_height'                                 => [
						'height' => 90,
						'units'  => 'px',
					],
				],
				'home-puppies'        => [
					'heading_color'                                 => '#222',
					'typography_body'                               => [
						'font-family' => 'Lora',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-family' => 'Lora',
						'font-weight' => '400',
					],
					'typography_heading_weight_2'                   => '500',
					'button_typography_custom'                      => [
						'font-size'      => '15px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'button_typography_custom_weight'               => '500',
					'button_rounded'                                => 0,
					'button_small_rounded'                          => 0,
					'button_large_rounded'                          => 0,
					'form_textarea_rounded'                         => 0,
					'form_input_small_rounded'                      => 0,
					'form_input_normal_rounded'                     => 0,
					'form_typography_inherit'                       => '1',
					'form_typography_custom_weight'                 => '500',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Lora',
						'font-weight'    => '400',
						'font-size'      => '14px',
						'line-height'    => '26px',
						'color'          => '#222222',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'global_top_bar'                                => '01',
					'top_bar_style_01_bg_color'                     => '#F7EEDF',
					'global_header'                                 => '03',
					'header_style_navigation_typography'            => [
						'font-family'    => 'Lora',
						'font-weight'    => '600',
						'font-size'      => '16px',
						'line-height'    => '22px',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'header_style_03_info_list_enable'              => '0',
					'header_style_03_language_switcher_enable'      => '0',
					'header_style_03_header_above_enable'           => '0',
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
				],
				'home-keyboard'       => [
					'primary_color'                                 => '#2D5BFE',
					'typography_body'                               => [
						'font-family' => 'ClashDisplay',
						'font-weight' => '500',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-family' => 'ClashDisplay',
						'font-weight' => '600',
					],
					'typography_heading_weight_2'                   => '600',
					'button_typography_custom'                      => [
						'font-size'      => '15px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'button_typography_custom_weight'               => '600',
					'button_rounded'                                => 10,
					'button_small_rounded'                          => 5,
					'button_large_rounded'                          => 10,
					'form_textarea_rounded'                         => 5,
					'form_input_small_rounded'                      => 5,
					'form_input_normal_rounded'                     => 10,
					'form_typography_inherit'                       => '1',
					'form_typography_custom'                        => [
						'font-size'      => '16px',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'form_typography_custom_weight'                 => '500',
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'ClashDisplay',
						'font-weight'    => '500',
						'font-size'      => '14px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'global_top_bar'                                => 'none',
					'top_bar_style_01_bg_color'                     => '#2D5BFE',
					'global_header'                                 => '03',
					'header_style_navigation_typography'            => [
						'font-family'    => 'ClashDisplay',
						'font-weight'    => '600',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'header_style_03_info_list_enable'              => '0',
					'header_style_03_language_switcher_enable'      => '0',
					'header_style_03_header_above_enable'           => '0',
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#2D5BFE',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#2D5BFE',
				],
				'home-halloween'      => [
					'primary_color'                                  => '#FF7A15',
					'heading_color'                                  => '#000000',
					'typography_body'                                => [
						'font-family' => 'Open Sans',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                             => [
						'font-family' => 'Open Sans',
						'font-weight' => '600',
					],
					'typography_heading_weight_2'                    => '400',
					'typography_heading2'                            => [
						'font-family' => 'Open Sans Condensed',
						'font-weight' => '300',
					],
					'button_typography_custom'                       => [
						'font-size'      => '16px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '',
					],
					'button_typography_custom_weight'                => '400',
					'button_rounded'                                 => 5,
					'button_small_rounded'                           => 5,
					'button_large_rounded'                           => 5,
					'form_textarea_rounded'                          => 5,
					'form_input_small_rounded'                       => 5,
					'form_input_normal_rounded'                      => 5,
					'form_typography_inherit'                        => '1',
					'form_typography_custom_weight'                  => '400',
					'button_text_color'                              => '#000000',
					'button_hover_text_color'                        => '#000000',
					'button_background_color'                        => '#ffffff',
					'button_border_color'                            => '#000000',
					'button_hover_background_color'                  => '#ffffff',
					'button_hover_border_color'                      => '#000000',
					'top_bar_style_01_text_typography'               => [
						'font-family'    => 'Open Sans',
						'font-weight'    => '600',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#121212',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'                      => '#CCE156',
					'top_bar_style_01_link_color'                    => '#121212',
					'top_bar_style_01_link_hover_color'              => '#121212',
					'global_header'                                  => '03',
					'header_style_navigation_typography'             => [
						'font-family'    => 'Open Sans',
						'font-weight'    => '600',
						'font-size'      => '18px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '',
					],
					'header_style_light_icon_badge_text_color'       => '#fff',
					'header_style_light_icon_badge_background_color' => '#000',
					'header_style_dark_icon_badge_text_color'        => '#000',
					'header_style_dark_icon_badge_background_color'  => '#FF7A15',
					'header_sticky_icon_badge_text_color'            => '#000',
					'header_sticky_icon_badge_background_color'      => '#FF7A15',
					'header_style_dark_text_color'                   => '#000',
					'header_icons_style'                             => 'icon-set-04',
					'header_cart_icon_style'                         => 'icon-set-04',
					'header_style_dark_nav_link_color'               => '#121212',
					'header_style_dark_nav_link_hover_color'         => '#FF7A15',
					'header_style_dark_icon_color'                   => '#121212',
					'header_style_dark_icon_hover_color'             => '#FF7A15',

					// Shop badges.
					'shop_badges_style'                              => 'semi-round-border-label',
					'shop_badge_sale_text_color'                     => '#000',
					'shop_badge_new_text_color'                      => '#000',
					'shop_badge_hot_text_color'                      => '#000',
					'shop_badge_best_selling_text_color'             => '#000',
					// Shop Price.
					'price_old_color'                                => '#808080',
					'price_regular_color'                            => '#000000',
					'price_sale_color'                               => '#FF7A15',
				],
				'home-bfcm-coachella' => [
					'typography_body'                               => [
						'font-family' => 'Inter',
						'font-weight' => '400',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-family' => 'Butler',
						'font-weight' => '500',
					],
					'button_typography_custom'                      => [
						'font-size'      => '15px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'button_typography_custom_weight'               => '400',
					'form_input_small_rounded'                      => 0,
					'form_input_normal_rounded'                     => 0,
					'form_textarea_rounded'                         => 0,
					'button_small_rounded'                          => 0,
					'button_rounded'                                => 0,
					'button_large_rounded'                          => 0,
					'top_bar_style_01_text_typography'              => [
						'font-family'    => 'Inter',
						'font-weight'    => '400',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#000',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'top_bar_style_01_bg_color'                     => '#E0E7E4',
					'top_bar_style_01_link_color'                   => '#000000',
					'top_bar_style_01_link_hover_color'             => '#000000',
					'header_style_navigation_typography'            => [
						'font-family'    => 'Inter',
						'font-weight'    => '400',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'header_style_dark_icon_badge_text_color'       => '#fff',
					'header_style_dark_icon_badge_background_color' => '#000',
					'header_sticky_icon_badge_text_color'           => '#fff',
					'header_sticky_icon_badge_background_color'     => '#000',
					'logo_padding'                                  => array(
						'padding-top'    => '11',
						'padding-right'  => '0',
						'padding-bottom' => '11',
						'padding-left'   => '0',
						'units'          => 'px',
					),
					'header_navigation_item_hover_style'            => 'thin-line',
					'header_icons_style'                            => 'icon-set-02',
					'header_cart_icon_style'                        => 'icon-set-02',
				],
				'home-stroller'       => [
					'primary_color'                                 => '#FAE0D5',
					'heading_color'                                 => '#222',
					'typography_body'                               => [
						'font-family' => 'Raleway',
						'font-weight' => '500',
						'font-size'   => '16px',
						'line-height' => '28px',
					],
					'typography_heading'                            => [
						'font-family' => 'Raleway',
						'font-weight' => '700',
					],
					'typography_heading_weight_2'                   => '700',
					'typography_heading2'                           => [
						'font-family' => 'Playfair Display',
						'font-weight' => '500',
					],
					'button_typography_custom'                      => [
						'font-size'      => '15px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'button_typography_custom_weight'               => '700',
					'form_input_small_rounded'                      => 0,
					'form_input_normal_rounded'                     => 0,
					'form_textarea_rounded'                         => 0,
					'button_small_rounded'                          => 0,
					'button_rounded'                                => 0,
					'button_large_rounded'                          => 0,
					'form_typography_inherit'                       => '1',
					'form_typography_custom_weight'                 => '500',
					'button_text_color'                             => '#222',
					'button_background_color'                       => '#FAE0D5',
					'button_border_color'                          => '#FAE0D5',
					'button_hover_text_color'                      => '#222',
					'button_hover_background_color'                => '#FAE0D5',
					'button_hover_border_color'                    => '#FAE0D5',
					'top_bar_style_01_text_typography'             => [
						'font-family'    => 'Raleway',
						'font-weight'    => '500',
						'font-size'      => '15px',
						'line-height'    => '26px',
						'color'          => '#fff',
						'text-transform' => '',
						'letter-spacing' => '',
					],
					'global_top_bar'                               => 'none',
					'header_style_navigation_typography'           => [
						'font-family'    => 'Raleway',
						'font-weight'    => '700',
						'font-size'      => '15px',
						'line-height'    => '22px',
						'text-transform' => 'uppercase',
						'letter-spacing' => '1px',
					],
					'header_above_style_dark_background'           => array(
						'background-color' => '#23441D',
					),
					'header_above_style_dark_border_color'         => 'rgba(0,0,0,0)',
					'header_above_style_dark_item_separator_color' => '#fff',
					'header_above_style_dark_text_color'            => '#fff',
					'header_above_style_dark_link_color'            => '#fff',
					'header_above_style_dark_link_hover_color'      => 'rgba(255,255,255,0.7)',
					'header_style_dark_nav_link_color'              => '#222',
					'header_style_dark_nav_line_color'              => '#DCDCDC',
					'header_style_dark_text_color'                  => '#222',
					'header_style_dark_icon_badge_text_color'       => '#222',
					'header_style_dark_icon_badge_background_color' => '#FAE0D5',
					'header_sticky_icon_badge_text_color'           => '#222',
					'header_sticky_icon_badge_background_color'     => '#FAE0D5',
					'header_icons_display'                          => 'text',
					'header_icons_style'                            => 'icon-set-05',
					'header_cart_icon_style'                        => 'icon-set-05',
					'header_height'                                 => [
						'height' => 80,
						'units'  => 'px',
					],
					'price_regular_color'                           => '#23441D',
					'price_old_color'                               => '#999',
					'price_sale_color'                              => '#E75E56',
				],
			];
		}
	}

	Minimog_Redux_Presets::instance()->initialize();
}
